@echo off
setlocal EnableDelayedExpansion

echo ========================================
echo   FFmpeg Status Analysis Tool
echo ========================================
echo.
echo This tool investigates the current FFmpeg installation status
echo and suggests recommended actions.
echo No changes will be made to your system.
echo.
echo Starting analysis...
echo.

REM Initialize variables
set "FOUND=0"

REM Check PATH recognition
where ffmpeg.exe >nul 2>&1
if %errorlevel% equ 0 (
    echo FFmpeg is recognized in PATH.
    echo.
    echo Recognized location:
    where ffmpeg.exe
    echo.
    echo Version information:
    ffmpeg -version 2>nul | find "ffmpeg version"
    echo.
    powershell -Command "Write-Host 'Assessment: FFmpeg is properly installed.' -ForegroundColor Green"
    echo.
    echo Recommended action:
    echo - Continue using as is
    echo - Or consider updating to the latest version
    
) else (
    echo FFmpeg is not recognized in PATH.
    echo.
    
    echo Searching for FFmpeg files...
    echo.
    
    echo Checking C:\ffmpeg\bin...
    if exist "C:\ffmpeg\bin\ffmpeg.exe" (
        echo   Found
        set "FOUND=1"
    ) else (
        echo   Not found
    )
    
    echo Checking "C:\Program Files\ffmpeg\bin"...
    if exist "C:\Program Files\ffmpeg\bin\ffmpeg.exe" (
        echo   Found
        set "FOUND=1"
    ) else (
        echo   Not found
    )
    
    echo Checking "C:\Program Files (x86)\ffmpeg\bin"...
    if exist "C:\Program Files (x86)\ffmpeg\bin\ffmpeg.exe" (
        echo   Found
        set "FOUND=1"
    ) else (
        echo   Not found
    )
    
    echo Checking %USERPROFILE%\ffmpeg\bin...
    if exist "%USERPROFILE%\ffmpeg\bin\ffmpeg.exe" (
        echo   Found
        set "FOUND=1"
    ) else (
        echo   Not found
    )
    
    echo Checking C:\tools\ffmpeg\bin...
    if exist "C:\tools\ffmpeg\bin\ffmpeg.exe" (
        echo   Found
        set "FOUND=1"
    ) else (
        echo   Not found
    )
    
    echo Checking C:\Software\ffmpeg\bin...
    if exist "C:\Software\ffmpeg\bin\ffmpeg.exe" (
        echo   Found
        set "FOUND=1"
    ) else (
        echo   Not found
    )
    echo.
    
    if "!FOUND!"=="1" (
        echo.
        powershell -Command "Write-Host 'Assessment: FFmpeg was found but PATH is not configured.' -ForegroundColor Yellow"
        echo.
        echo Recommended action:
        echo - Configure PATH to make FFmpeg available.
    ) else (
        
        powershell -Command "Write-Host 'Assessment: FFmpeg not found in common directories.' -ForegroundColor Red"
        echo.
        echo Recommended action:
        echo - If not installed elsewhere, a new installation is required.
        echo - If installed in a different location, please configure PATH.
    )
)

echo.
echo Analysis complete
echo.
echo Press any key to exit...
pause >nul
