@echo off
setlocal EnableDelayedExpansion
echo ========================================
echo   FFmpeg Complete Uninstaller
echo ========================================
echo.

REM Check for administrator privileges
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo [INFO] No administrator privileges.
    echo If you cannot delete C:\ffmpeg, please run as administrator.
    echo.
    timeout /t 3 >nul
)

REM Check current FFmpeg status
echo Checking current FFmpeg status...
echo.

REM Check file existence
if exist "C:\ffmpeg" (
    echo [OK] C:\ffmpeg folder exists
    if exist "C:\ffmpeg\bin\ffmpeg.exe" (
        echo [OK] FFmpeg executable exists
        
        REM Display file size
        for %%F in ("C:\ffmpeg\bin\ffmpeg.exe") do (
            echo   Size: %%~zF bytes
            echo   Modified: %%~tF
        )
    ) else (
        echo [X] FFmpeg executable not found
    )
) else (
    echo [X] C:\ffmpeg folder does not exist
)
echo.

REM Check PATH
echo Checking PATH environment variable...
for /f "tokens=2*" %%i in ('reg query "HKCU\Environment" /v PATH 2^>nul ^| find "PATH"') do set USER_PATH=%%j
if defined USER_PATH (
    echo !USER_PATH! | find /i "ffmpeg" >nul
    if !errorlevel! equ 0 (
        echo [OK] User PATH contains FFmpeg-related settings
    ) else (
        echo [X] User PATH does not contain FFmpeg-related settings
    )
) else (
    echo [X] User PATH is not configured
)

REM Check system PATH
reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v PATH 2>nul | find /i "ffmpeg" >nul
if !errorlevel! equ 0 (
    echo [OK] System PATH contains FFmpeg-related settings
) else (
    echo [X] System PATH does not contain FFmpeg-related settings
)
echo.

REM Check functionality
where ffmpeg.exe >nul 2>&1
if %errorlevel% equ 0 (
    echo [OK] FFmpeg is currently recognized by the system
    where ffmpeg.exe
) else (
    echo [X] FFmpeg is not currently recognized by the system
)
echo.

REM Check if FFmpeg is installed at all
set FFMPEG_FOUND=0
if exist "C:\ffmpeg" set FFMPEG_FOUND=1
for /f "tokens=2*" %%i in ('reg query "HKCU\Environment" /v PATH 2^>nul ^| find "PATH"') do (
    echo %%j | find /i "ffmpeg" >nul
    if !errorlevel! equ 0 set FFMPEG_FOUND=1
)
reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v PATH 2>nul | find /i "ffmpeg" >nul
if !errorlevel! equ 0 set FFMPEG_FOUND=1

if %FFMPEG_FOUND%==0 (
    echo ========================================
    echo   FFmpeg Not Installed
    echo ========================================
    echo.
    echo FFmpeg is not installed on this system.
    echo No uninstallation needed.
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 0
)

REM Confirmation message
echo ========================================
echo   Uninstallation Confirmation
echo ========================================
echo.
echo The following operations will be performed:
echo   1. Complete deletion of C:\ffmpeg folder
echo   2. Remove FFmpeg path from user PATH environment variable
echo   3. Remove FFmpeg path from system PATH (if exists)
echo   4. Notify Windows system of environment variable changes
echo   5. Clean up temporary files
echo.

set /p "CONFIRM=Do you really want to uninstall? (Y/N): "
if /i not "!CONFIRM!"=="Y" (
    echo Uninstallation cancelled.
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 0
)

echo.
echo Starting uninstallation...
echo.

REM Step 1: Delete folder
echo [1/5] Deleting C:\ffmpeg folder...
set FOLDER_DELETED=0
if exist "C:\ffmpeg" (
    REM Remove read-only attribute
    attrib -R "C:\ffmpeg\*" /S /D >nul 2>&1
    
    REM Delete folder
    rmdir /s /q "C:\ffmpeg" >nul 2>&1
    
    if exist "C:\ffmpeg" (
        echo [WARNING] Failed to delete C:\ffmpeg.
        echo Please run as administrator or delete manually.
    ) else (
        echo [OK] C:\ffmpeg folder deleted
        set FOLDER_DELETED=1
    )
) else (
    echo [X] C:\ffmpeg folder does not exist
)

REM Step 2: Modify user PATH environment variable
echo [2/5] Modifying user PATH environment variable...
set USER_PATH_REMOVED=0
if defined USER_PATH (
    echo !USER_PATH! | find /i "ffmpeg" >nul
    if !errorlevel! equ 0 (
        REM PowerShell script to remove FFmpeg-related paths
        powershell.exe -Command "& {$userPath = [System.Environment]::GetEnvironmentVariable('PATH', 'User'); if ($userPath) {$pathArray = $userPath -split ';' | Where-Object {$_ -and $_ -notlike '*ffmpeg*'}; $newPath = $pathArray -join ';'; [System.Environment]::SetEnvironmentVariable('PATH', $newPath, 'User'); Write-Host '[OK] FFmpeg path removed from user PATH' -ForegroundColor Green; exit 0} else {Write-Host '[X] User PATH is not configured' -ForegroundColor Yellow; exit 1}}"
        if !errorlevel! equ 0 set USER_PATH_REMOVED=1
    ) else (
        echo [X] User PATH does not contain FFmpeg-related settings
    )
) else (
    echo [X] User PATH is not configured
)

REM Step 3: Check system PATH (requires administrator privileges)
echo [3/5] Checking system PATH environment variable...
reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v PATH 2>nul | find /i "ffmpeg" >nul
if !errorlevel! equ 0 (
    echo [NOTE] System PATH contains FFmpeg-related settings.
    echo Running as administrator will allow automatic removal.
    echo For manual removal, follow these steps:
    echo   1. System Settings -> Advanced -> Environment Variables
    echo   2. Edit system PATH variable
    echo   3. Remove FFmpeg-related paths (*ffmpeg*)
) else (
    echo [OK] System PATH does not contain FFmpeg-related settings
)

REM Step 4: Notify environment variable changes
echo [4/5] Notifying system of environment variable changes...
powershell.exe -Command "& {Add-Type -Namespace Win32 -Name NativeMethods -MemberDefinition '[DllImport(\"user32.dll\", SetLastError = true, CharSet = CharSet.Auto)] public static extern IntPtr SendMessageTimeout(IntPtr hWnd, uint Msg, UIntPtr wParam, string lParam, uint fuFlags, uint uTimeout, out UIntPtr lpdwResult);'; $HWND_BROADCAST = [IntPtr]0xffff; $WM_SETTINGCHANGE = 0x1a; $result = [UIntPtr]::Zero; [Win32.NativeMethods]::SendMessageTimeout($HWND_BROADCAST, $WM_SETTINGCHANGE, [UIntPtr]::Zero, 'Environment', 2, 5000, [ref]$result) | Out-Null; Write-Host '[OK] Environment variable change notification sent' -ForegroundColor Green}"

REM Step 5: Clean up temporary files
echo [5/5] Cleaning up temporary files...
set TEMP_FILES_CLEANED=0
if exist "%TEMP%\ffmpeg_installer" (
    rmdir /s /q "%TEMP%\ffmpeg_installer" >nul 2>&1
    echo [OK] FFmpeg installer temporary files deleted
    set TEMP_FILES_CLEANED=1
) else (
    echo [X] No FFmpeg installer temporary files found
)

echo.

REM Check if any operations were performed
if %FOLDER_DELETED%==0 if %USER_PATH_REMOVED%==0 if %TEMP_FILES_CLEANED%==0 (
    echo ========================================
    echo   No Action Required
    echo ========================================
    echo.
    echo FFmpeg is not installed on this system.
    echo No uninstallation needed.
) else (
    echo ========================================
    echo   Uninstallation Complete
    echo ========================================
    echo.
    echo * Operations Performed
    if %FOLDER_DELETED%==1 echo   [OK] Deleted C:\ffmpeg folder
    if %USER_PATH_REMOVED%==1 echo   [OK] Removed FFmpeg path from user PATH
    echo   [OK] Notified system of environment variable changes
    if %TEMP_FILES_CLEANED%==1 echo   [OK] Cleaned up temporary files
)
echo.
echo * Verification Method
echo   Open a new Command Prompt and run:
echo.  
echo   where ffmpeg.exe
echo   -> If 'INFO: Could not find files for the given pattern(s).' appears, success
echo.
echo * Complete Removal Verification
echo   1. Open a new Command Prompt/PowerShell
echo   2. Run: ffmpeg -version
echo   3. If 'is not recognized' error appears, complete removal successful
echo.
echo * Reinstallation
echo   If you want to use FFmpeg again,
echo   run the FFmpeg installer.
echo.
echo ========================================
echo   FFmpeg Uninstallation Complete
echo ========================================
echo.
echo Press any key to exit...
pause >nul
